#include "pch.h"
#include "Game.h"

namespace ABI
{
	namespace Library3
	{
		Game::Game()
		{
			m_observed = false;
		}

		STDMETHODIMP Game::get_RegisterUser(HSTRING* value)
		{
			HString str;
			str.Set(name.c_str());
			*value = str.Detach();
			return S_OK;
		}

		STDMETHODIMP Game::put_RegisterUser(HSTRING value)
		{
			HString str;
			str.Set(value);
			name = str.GetRawBuffer(nullptr);
			return S_OK;
		}

		STDMETHODIMP Game::StartGame(HSTRING value)
		{
			HString str;
			str.Set(value);
			std::wstring ws = str.GetRawBuffer(nullptr);
			Notify(value);
			return S_OK;
		}

		STDMETHODIMP Game::add_UserLogged(IGameEventHandler* handler, EventRegistrationToken* token)
		{
			m_observed = true;
			m_events.Add(handler, token);
			return S_OK;
		}

		STDMETHODIMP Game::remove_UserLogged(EventRegistrationToken token)
		{
			m_events.Remove(token);
			return S_OK;
		}

		void Game::Notify(HSTRING value)
		{
			if (m_observed)
			{
				HString str;
				str.Set(value);
				m_events.InvokeAll(str.Detach());
			}
		}
	}
}
